/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DMARIADBREALQUERYONQTHREAD_H
#define DMARIADBREALQUERYONQTHREAD_H

#include <QThread>

#if defined(Q_OS_WIN)
  #include "mysql.h"
#elif defined(Q_OS_LINUX)
  #include "mysql.h"
#elif defined(Q_OS_MAC)
  #include "mysql.h"
#endif

/**
 * @brief The DMariaDBRealQueryOnQThread class executes a raw MariaDB query in a background thread.
 *
 * This class inherits from QThread and provides a mechanism to run blocking
 * C-API MySQL functions (like `mysql_real_query`) without freezing the main
 * application or GUI thread.
 */
class DMariaDBRealQueryOnQThread : public QThread
{
  Q_OBJECT

  /**
   * @brief The entry point for the thread.
   *
   * Overrides QThread::run() to execute the SQL statement stored in this object
   * using the provided MySQL connection handle.
   */
  void run() override;

public:
  /**
   * @brief Constructs the thread object.
   * @param serverConnection A pointer to the raw MYSQL connection structure.
   */
  DMariaDBRealQueryOnQThread(MYSQL *serverConnection);

  /**
   * @brief Sets the SQL statement to be executed by the thread.
   * @param statement The SQL query string (std::string).
   */
  void setStatement(std::string statement);

private:
  MYSQL *serverConnection;
  std::string statement;
};

#endif // DMARIADBREALQUERYONQTHREAD_H
