/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2022 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DMAIRADBREALQUERYONQTHREAD_H
#define DMAIRADBREALQUERYONQTHREAD_H

#include <QThread>

#if defined(Q_OS_WIN)
  #include "mysql.h"
#elif defined(Q_OS_LINUX)
  #include "mysql.h"
#elif defined(Q_OS_MAC)
  #include "mysql.h"
#endif

class DMairaDBRealQueryOnQThread : public QThread
{
  Q_OBJECT

  void run() override;

public:
  DMairaDBRealQueryOnQThread(MYSQL *serverConnection);
  void setStatement(std::string statement);

private:
  MYSQL *serverConnection;
  std::string statement;
};

#endif // DMAIRADBREALQUERYONQTHREAD_H
