/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DLOADDATA_H
#define DLOADDATA_H

#include "dmdisubwindow.h"
#include "dbms.h"
#include "dsettings.h"

class DTitleLabel;
class DFileSelector;
class QGroupBox;
class QFormLayout;
class QLabel;
class QGroupBox;
class BaseTextEditor;
class QGridLayout;
class QDialogButtonBox;
class QAbstractButton;
class QCheckBox;
class DMessageLabel;
class QLineEdit;
class QCompleter;

/**
 * @brief The DLoadData class provides an interface for importing external data.
 *
 * This class inherits from DMdiSubWindow and facilitates the construction and
 * execution of SQL "LOAD DATA" statements. It allows users to select a source file,
 * configure parsing options (headers, CSV format), and define the target database/table.
 */
class DLoadData : public DMdiSubWindow
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DLoadData window.
   * @param serverConnection Pointer to the active DBMS connection used for the import.
   */
  DLoadData(DBMS *serverConnection);

  /**
   * @brief Retranslates the user interface.
   *
   * Updates labels and tooltips to match the current application language.
   */
  void retranslateUI();

private:
  DBMS *serverConnection;
  DTitleLabel *dTitleLabel;
  DFileSelector *dFileSelector;
  DSettings settings;
  QGroupBox *fileGroupBox;
  QFormLayout *fileGroupBoxLayout;
  QLabel *fileLabel;
  QLabel *dataLengthLabel;
  QGroupBox *optionsGroupBox;
  BaseTextEditor *baseTextEditor;
  QGridLayout *optionsGroupBoxLayout;
  QDialogButtonBox *buttonBox;
  QCheckBox *useFirstLineForHeaders;
  QCheckBox *createABasicTable;
  QCheckBox *showTop100Rows;
  DMessageLabel *dMessageLabel;
  QLabel *tableToUse;
  QLabel *databaseToUse;
  QLineEdit *databaseLineEdit;
  QLineEdit *tableLineEdit;
  QCompleter *databaseCompleter;
  QCompleter *tableCompleter;

  /**
   * @brief Generates the SQL statement for loading data.
   *
   * Constructs the query string based on selected file options and target table.
   * @return A QString containing the generated SQL.
   */
  QString loadDataStatement();

private slots:
  /**
   * @brief Reads the file to preview data or extract headers.
   * @param state The state of the triggering checkbox (e.g., use headers).
   */
  void getFileHeader(int state = 0);

  /**
   * @brief Handles the execution trigger (OK button).
   *
   * Validates inputs and runs the generated load data statement.
   */
  void acceptedSlot();

  /**
   * @brief Updates the table auto-completer based on the selected database.
   * @param text The name of the database currently entered.
   */
  void databaseCompleterTextChanged(QString text);
};

#endif // DLOADDATA_H
