/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DLISTWIDGETDIALOG_H
#define DLISTWIDGETDIALOG_H

#include <QDialog>

class QDialogButtonBox;
class QListWidget;

/**
 * @brief The DListWidgetDialog class provides a simple item selection dialog.
 *
 * This dialog presents a list of strings to the user via a QListWidget,
 * allowing them to select one or multiple items before accepting the dialog.
 */
class DListWidgetDialog : public QDialog
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DListWidgetDialog.
   * @param items A list of strings to populate the selection widget.
   */
  DListWidgetDialog(QStringList items = QStringList());

  /**
   * @brief Retrieves the items selected by the user.
   * @return A QStringList containing the text of the selected items.
   */
  QStringList selectedItems();

private:
  QDialogButtonBox *buttonBox;
  QListWidget *dListWidgetTables;
};

#endif // DLISTWIDGETDIALOG_H
