/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QDialogButtonBox>
#include <QVBoxLayout>
#include <QListWidget>

#include "dlistwidgetdialog.h"
#include "dtitlelabel.h"
#include "dicon.h"

DListWidgetDialog::DListWidgetDialog(QStringList items)
{
  setWindowTitle(tr("Migrate tables"));
  setObjectName(windowTitle());
  setWindowIcon(DIcon::DatabaseTable());

  buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
  connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

  dListWidgetTables = new QListWidget();
  dListWidgetTables->setSelectionMode(QAbstractItemView::MultiSelection);
  dListWidgetTables->addItems(items);

  QVBoxLayout *verticalLayout = new QVBoxLayout;
  verticalLayout->addWidget(new DTitleLabel(windowTitle()));
  verticalLayout->addWidget(dListWidgetTables);
  verticalLayout->addWidget(buttonBox);
  setLayout(verticalLayout);
}

QStringList DListWidgetDialog::selectedItems()
{
  QStringList list;
  for (int counter = 0; counter < dListWidgetTables->selectedItems().count(); counter++)
    list.append(dListWidgetTables->selectedItems().at(counter)->text());
  return list;
}
