/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DIFFFILE_H
#define DIFFFILE_H

class QFileInfo;
class DTitleLabel;

#include "dmdisubwindow.h"

/**
 * @brief The DiffFile class provides a window to view file differences.
 *
 * This class inherits from DMdiSubWindow and is designed to display
 * version control differences (specifically for SVN, based on internal members)
 * for a specific file.
 */
class DiffFile : public DMdiSubWindow
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DiffFile window.
   * @param file The path to the file for which differences will be shown.
   */
  DiffFile(QString file);

private:
  QFileInfo *svnFile;
  DTitleLabel *dTitleLabel;

  /**
   * @brief Retranslates the user interface.
   *
   * Updates the window title and other textual elements to match the
   * currently selected application language.
   */
  void retranslateUI();

};

#endif // DIFFFILE_H
