/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QRandomGenerator>

#include "dicon.h"
#include "dsettings.h"

DIcon::DIcon()
{

}
// https://specifications.freedesktop.org/icon-naming-spec/icon-naming-spec-latest.html

QIcon DIcon::DocumentClose()
{
  return QIcon(DocumentCloseIconPath());
}

QString DIcon::DocumentCloseIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/document-close-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DocumentNew()
{
  return QIcon(DocumentNewIconPath());
}

QString DIcon::DocumentNewIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/document-new-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Import()
{
  return QIcon(ImportIconPath());
}

QString DIcon::ImportIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/import-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Print()
{
  DSettings settings;
  return QIcon(":/images/png/256/document-print-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DocumentOpen()
{
  return QIcon(DocumentOpenIconPath());
}

QString DIcon::DocumentOpenIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/document-open-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Save()
{
  DSettings settings;
  return QIcon(":/images/png/256/document-save-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::SaveAs()
{
  DSettings settings;
  return QIcon(":/images/png/256/document-save-as-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Copy()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-copy-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Cut()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-cut-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Paste()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-paste-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Undo()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-undo-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Redo()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-redo-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Clear()
{
  return QIcon(ClearIconPath());
}

QString DIcon::ClearIconPath()
{
  DSettings settings;
  return ":/images/png/256/edit-clear-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseRollback()
{
  return QIcon(DatabaseRollbackIconPath());
}

QString DIcon::DatabaseRollbackIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-rollback-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DocumentRevert()
{
  return QIcon(DocumentRevertIconPath());
}

QString DIcon::DocumentRevertIconPath()
{
  DSettings settings;
  return ":/images/png/256/document-revert-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::ZoomIn() { return QIcon::fromTheme("zoom-in", QIcon(":/images/svg/zoom-in-5.svg")); }
QIcon DIcon::ZoomOut() { return QIcon::fromTheme("zoom-out", QIcon(":/images/svg/zoom-out-5.svg")); }
QIcon DIcon::ZoomOriginal() { return QIcon::fromTheme("zoom-original", QIcon(":/images/svg/zoom-original-4.svg")); }
QIcon DIcon::Refresh() { return QIcon::fromTheme("view-refresh", QIcon(":/images/svg/view-refresh-7.svg")); }
QIcon DIcon::ListAdd() { return QIcon::fromTheme("list-add", QIcon(":/images/svg/list-add-5.svg")); }
QIcon DIcon::ListRemove() { return QIcon::fromTheme("list-remove", QIcon(":/images/svg/list-remove-5.svg")); }

QIcon DIcon::SelectAll()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-select-all-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Database()
{
  return QIcon(DatabaseIconPath());
}

QString DIcon::DatabaseIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseTable()
{
  return QIcon(DatabaseTableIconPath());
}

QString DIcon::DatabaseTableIconPath()
{
  DSettings settings;
  return ":/images/png/256/table-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseTableStatus()
{
  DSettings settings;
  return QIcon(":/images/png/256/table-status-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DatabaseView()
{
  return QIcon(DatabaseViewIconPath());
}

QString DIcon::DatabaseViewIconPath()
{
  DSettings settings;
  return ":/images/png/256/view-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseRoutine()
{
  return QIcon(DatabaseRoutineIconPath());
}

QString DIcon::DatabaseRoutineIconPath()
{
  DSettings settings;
  return ":/images/png/256/routine-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseTrigger()
{
  return QIcon(DIcon::DatabaseTriggerIconPath());
}

QString DIcon::DatabaseTriggerIconPath()
{
  DSettings settings;
  return ":/images/png/256/trigger-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseQuery()
{
  DSettings settings;
  return QIcon(":/images/png/256/query-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DatabaseEvent()
{
  return QIcon(DIcon::DatabaseEventIconPath());
}

QString DIcon::DatabaseEventIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-event-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseProcessList()
{
  DSettings settings;
  return QIcon(":/images/png/256/process-list-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Caliope()
{
  DSettings settings;
  return QIcon(":/images/png/512/Caliope-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Dashboard()
{
  return QIcon(DIcon::DashboardIconPath());
}

QString DIcon::DashboardIconPath()
{
  DSettings settings;
  return ":/images/png/256/dashboard-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::Preferences()
{
  return QIcon(DIcon::PreferencesIconPath());
}

QString DIcon::PreferencesIconPath()
{
  DSettings settings;
  return ":/images/png/256/preferences-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseBackup()
{
  return QIcon(DIcon::DatabaseBackupIconPath());
}

QString DIcon::DatabaseBackupIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-backup-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseRestore()
{
  return QIcon(DIcon::DatabaseRestoreIconPath());
}

QString DIcon::DatabaseRestoreIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-restore-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::LoadData()
{
  return QIcon(DIcon::LoadDataIconPath());
}

QString DIcon::LoadDataIconPath()
{
  DSettings settings;
  return ":/images/png/256/load-data-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseComparison()
{
  return QIcon(DIcon::DatabaseComparisonIconPath());
}

QString DIcon::DatabaseComparisonIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-comparison-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseMigration()
{
  return QIcon(DIcon::DatabaseMigrationIconPath());
}

QString DIcon::DatabaseMigrationIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-migration-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseMonitorig()
{
  return QIcon(DIcon::DatabaseMonitorigIconPath());
}

QString DIcon::DatabaseMonitorigIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-monitoring-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseSELECT()
{
  return QIcon(DIcon::DatabaseSELECTIconPath());
}

QString DIcon::DatabaseSELECTIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-select-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseUPDATE()
{
  return QIcon(DIcon::DatabaseUPDATEIconPath());
}

QString DIcon::DatabaseUPDATEIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-update-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseINSERT()
{
  return QIcon(DIcon::DatabaseINSERTIconPath());
}

QString DIcon::DatabaseINSERTIconPath()
{
  DSettings settings;
  return ":/images/png/256/database-insert-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::FileSQL()
{
  return QIcon(FileSQLIconPath());
}

QString DIcon::FileSQLIconPath()
{
  DSettings settings;
  return ":/images/png/256/file-sql-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::FileTXT()
{
  return QIcon(FileTXTIconPath());
}

QString DIcon::FileTXTIconPath()
{
  DSettings settings;
  return ":/images/png/256/file-txt-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::FileCSS()
{
  return QIcon(FileCSSIconPath());
}

QString DIcon::FileCSSIconPath()
{
  DSettings settings;
  return ":/images/png/256/file-css-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::FileHTML()
{
  return QIcon(FileHTMLIconPath());
}

QString DIcon::FileHTMLIconPath()
{
  DSettings settings;
  return ":/images/png/256/file-html-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::WordWrap()
{
  return QIcon(WordWrapIconPath());
}

QString DIcon::WordWrapIconPath()
{
  DSettings settings;
  return ":/images/png/256/word-wrap-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::DatabaseServer()
{
  DSettings settings;
  return QIcon(":/images/png/256/database-server-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DatabaseUser()
{
  DSettings settings;
  return QIcon(":/images/png/256/user-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DocumentOpenRecent()
{
  return QIcon(DocumentOpenRecentIconPath());
}

QString DIcon::DocumentOpenRecentIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/document-open-recent-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Key()
{
  return QIcon(KeyIconPath());
}

QString DIcon::KeyIconPath()
{
  DSettings settings;
  return ":/images/png/256/key-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::PEMKey()
{
  return QIcon(PEMKeyIconPath());
}

QString DIcon::PEMKeyIconPath()
{
  DSettings settings;
  return ":/images/png/256/pem-key-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::PEMCert()
{
  return QIcon(PEMCertIconPath());
}

QString DIcon::PEMCertIconPath()
{
  DSettings settings;
  return ":/images/png/256/pem-cert-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::Executable()
{
  DSettings settings;
  return QIcon(":/images/png/256/application-x-executable-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::PDF()
{
  DSettings settings;
  return QIcon(":/images/png/256/application-pdf-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::ImageSVG()
{
  DSettings settings;
  return QIcon(":/images/png/256/image-svg-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::ImagePNG()
{
  DSettings settings;
  return QIcon(":/images/png/256/image-png-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::ViewClose() { return QIcon(":/images/svg/view-close.svg"); }
QIcon DIcon::ViewSplitTopBottom() { return QIcon(":/images/svg/view-split-top-bottom-3.svg"); }
QIcon DIcon::ViewSplitLeftRight() { return QIcon(":/images/svg/view-split-left-right-3.svg"); }
QIcon DIcon::ViewFilter() { return QIcon(":/images/svg/view-filter.svg"); }
QIcon DIcon::ViewSortAscending() { return QIcon::fromTheme("view-sort-ascending", QIcon(":/images/svg/view-sort-ascending-2.svg")); }
QIcon DIcon::ViewFullscreen() { return QIcon::fromTheme("view-fullscreen", QIcon(":/images/svg/view-fullscreen-6.svg")); }
QIcon DIcon::FormatIndentMore() { return QIcon::fromTheme("format-indent-more", QIcon(":/images/svg/format-indent-more-4.svg")); }
QIcon DIcon::FormatIndentLess() { return QIcon::fromTheme("format-indent-less", QIcon(":/images/svg/format-indent-less-4.svg")); }

QIcon DIcon::Export()
{
  DSettings settings;
  return QIcon(":/images/png/256/export-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::QueryExecution()
{
  return QIcon(QueryExecutionIconPath());
}

QString DIcon::QueryExecutionIconPath()
{
  DSettings settings;
  return ":/images/png/256/query-execution-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::Stop()
{
  DSettings settings;
  return QIcon(":/images/png/256/process-stop-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Folder()
{
  return QIcon(FolderIconPath());
}

QString DIcon::FolderIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/folder-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DatabaseQueryLog()
{
  DSettings settings;
  return QIcon(":/images/png/256/query-log-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DatabaseReplication()
{
  DSettings settings;
  return QIcon(":/images/png/256/replication-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DatabaseMaintenance()
{
  DSettings settings;
  return QIcon(":/images/png/256/database-maintenance-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DatabaseQueryHistory()
{
  DSettings settings;
  return QIcon(":/images/png/256/query-history-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Information()
{
  DSettings settings;
  return QIcon(":/images/png/256/information-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::DialogWarning()
{
  return QIcon(DialogWarningIconPath());
}

QString DIcon::DialogWarningIconPath()
{
  DSettings settings;
  return ":/images/png/256/dialog-warning-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::Error()
{
  DSettings settings;
  return QIcon(":/images/png/256/error-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Close() { return QIcon::fromTheme("dialog-close", QIcon(":/images/svg/document-close-4.svg")); }

QIcon DIcon::TextEditor()
{
  DSettings settings;
  return QIcon(":/images/png/256/accessories-text-editor-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::GraphicsCharts()
{
  DSettings settings;
  return QIcon(":/images/png/256/graphic-charts-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Delete()
{
  return QIcon(DeleteIconPath());
}

QString DIcon::DeleteIconPath()
{
  DSettings settings;
  return ":/images/png/256/edit-delete-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::Trash()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-trash-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::TrashFull()
{
  DSettings settings;
  return QIcon(":/images/png/256/edit-trash-full-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::ObjectLocked()
{
  DSettings settings;
  return QIcon(":/images/png/256/object-locked-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::ObjectUnlocked()
{
  DSettings settings;
  return QIcon(":/images/png/256/object-unlocked-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::CharacterSet()
{
  DSettings settings;
  return QIcon(":/images/png/256/character-set-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Find()
{
  DSettings settings;
  return QIcon(":/images/png/256/find-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Replace()
{
  DSettings settings;
  return QIcon(":/images/png/256/find-replace-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::QtLogo() { return QIcon(":/images/svg/Qt-logo.svg"); }

QIcon DIcon::MariaDBSeal()
{
  return QIcon(":/images/png/256/MariaDB-seal.png");
}

QIcon DIcon::SVNLogo()
{
  return QIcon(":/images/svg/subversion_logo.svg");
}

//QIcon DIcon::ExecutableScript() { return QIcon(":/images/svg/application-x-executable-script.svg"); }
QIcon DIcon::WalletOpen() { return QIcon(":/images/svg/wallet-open.svg"); }

QIcon DIcon::MediaPause() { return QIcon::fromTheme("media-playback-pause", QIcon(":/images/svg/media-playback-pause-8.svg")); }

QIcon DIcon::MediaPlaybackStop()
{
  return QIcon(MediaPlaybackStopIconPath());
}

QString DIcon::MediaPlaybackStopIconPath()
{
  DSettings settings;
  return ":/images/png/256/media-playback-stop-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::MediaSkipBackward()
{
  return QIcon(MediaSkipBackwardIconPath());
}

QString DIcon::MediaSkipBackwardIconPath()
{
  DSettings settings;
  return ":/images/png/256/media-skip-backward-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::MediaSkipForward()
{
  return QIcon(MediaSkipForwardIconPath());
}

QString DIcon::MediaSkipForwardIconPath()
{
  DSettings settings;
  return ":/images/png/256/media-skip-forward-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::MediaSeekBackward()
{
  return QIcon(MediaSeekBackwardIconPath());
}

QString DIcon::MediaSeekBackwardIconPath()
{
  DSettings settings;
  return ":/images/png/256/media-seek-backward-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::MediaSeekForward()
{
  return QIcon(MediaSeekForwardIconPath());
}

QString DIcon::MediaSeekForwardIconPath()
{
  DSettings settings;
  return ":/images/png/256/media-seek-forward-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::MediaPlaybackStart()
{
  return QIcon(MediaPlaybackStartIconPath());
}

QString DIcon::MediaPlaybackStartIconPath()
{
  DSettings settings;
  return ":/images/png/256/media-playback-start-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::RepeateQueryExecution()
{
  DSettings settings;
  return QIcon(":/images/png/256/repeate-query-execution-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::HDDUsage()
{
  DSettings settings;
  return QIcon(":/images/png/256/hdd-usage-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::AttachResult()
{
  DSettings settings;
  return QIcon(":/images/png/256/attach-result-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::LockQueryExecution()
{
  DSettings settings;
  return QIcon(":/images/png/256/lock-query-execution-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::WindowClose()
{
  return QIcon(WindowCloseIconPath());
}

QString DIcon::WindowCloseIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/window-close-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::SystemShutdown()
{
  DSettings settings;
  return QIcon(":/images/png/256/shutdown-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Reboot()
{
  DSettings settings;
  return QIcon(":/images/png/256/reboot-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::Screenshot()
{
  DSettings settings;
  return QIcon(":/images/png/256/screenshot-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::AccessoriesCharacterMap()
{
  DSettings settings;
  return QIcon(":/images/png/256/accessories-character-map-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::FlagUS()
{
  return QIcon(":/images/png/256/flag-us.png");
}

QIcon DIcon::FlagCR()
{
  return QIcon(":/images/png/256/flag-cr.png");
}

QIcon DIcon::Help()
{
  DSettings settings;
  return QIcon(":/images/png/256/help-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QIcon DIcon::GitLab()
{
  return QIcon(":/images/png/256/gitlab-icon-rgb.png");
}

QIcon DIcon::EmblemDownloads()
{
  return QIcon(EmblemDownloadsIconPath());
}

QString DIcon::EmblemDownloadsIconPath()
{
  DSettings settings;
  return QString(":/images/png/256/emblem-downloads-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png");
}

QMovie DIcon::Loading()
{
  return QMovie(":/images/gif/Loading.gif");
}

QString DIcon::RandomCaliopeAt512px()
{
  QString image;
  switch (QRandomGenerator::global()->bounded(4)) {
  case 0:
    image = ":/images/png/512/Caliope-1.png";
    break;
  case 1:
    image = ":/images/png/512/Caliope-2.png";
    break;
  case 2:
    image = ":/images/png/512/Caliope-3.png";
    break;
  case 3:
    image = ":/images/png/512/Caliope-4.png";
    break;
  default:
    image = ":/images/png/512/Caliope-1.png";
    break;
  }
  return image;
}

QString DIcon::StartupTip1()
{
  DSettings settings;
  return ":/images/png/256/StartupTip-1.png";
}

QIcon DIcon::GoUp()
{
  return QIcon(GoUpIconPath());
}

QString DIcon::GoUpIconPath()
{
  DSettings settings;
  return ":/images/png/256/go-up-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::GoDown()
{
  return QIcon(GoDownIconPath());
}

QString DIcon::GoDownIconPath()
{
  DSettings settings;
  return ":/images/png/256/go-down-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::GoNext()
{
  return QIcon(GoNextIconPath());
}

QString DIcon::GoNextIconPath()
{
  DSettings settings;
  return ":/images/png/256/go-next-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::GoPrevious()
{
  return QIcon(GoPreviousIconPath());
}

QString DIcon::GoPreviousIconPath()
{
  DSettings settings;
  return ":/images/png/256/go-previous-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::GoJump()
{
  return QIcon(GoJumpIconPath());
}

QString DIcon::GoJumpIconPath()
{
  DSettings settings;
  return ":/images/png/256/go-jump-" + settings.value("GeneralSettings/IconsStyle", "Calíope - 1").toString().split(" - ").at(1) + ".png";
}

QIcon DIcon::GoTo() { return QIcon::fromTheme("go-jump", QIcon(":/images/svg/go-jump-4.svg")); }
