/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QHelpEngine>
#include <QHelpContentWidget>
#include <QHelpIndexWidget>
#include <QVBoxLayout>
#include <QSplitter>
#include <QTextBrowser>
//#include <QHelpSearchEngine>
#include <QFile>
#include <QDomDocument>
#include <QHelpSearchQueryWidget>
#include <QHelpSearchResultWidget>
#include <QHelpSearchEngine>

#include "dhelpviewer.h"
#include "dicon.h"
#include "dtitlelabel.h"

#include <QDebug>

DHelpViewer::DHelpViewer(QString collectionFileName, QString documentationFileName)
{
  setWindowIcon(DIcon::Help());
  QWidget *widMain = new QWidget;
  QVBoxLayout *mainVLayout = new QVBoxLayout;
  mainVLayout->setContentsMargins(3, 0, 3, 0);
  dTitleLabel = new DTitleLabel;
  mainVLayout->addWidget(dTitleLabel);

  QHelpEngine* helpEngine = new QHelpEngine(collectionFileName);
  helpEngine->setupData();
  tabWidget = new QTabWidget;
  tabWidget->setMaximumWidth(300);
  tabWidget->addTab(helpEngine->contentWidget(), "");
  tabWidget->addTab(helpEngine->indexWidget(), "");
  QVBoxLayout *widgetHLayout = new QVBoxLayout;
  helpSearchEngine = new QHelpSearchEngine(helpEngine);
  connect(helpSearchEngine->queryWidget(), SIGNAL(search()), this, SLOT(helpSearchEngineSearchSlot()));
  helpSearchEngine->reindexDocumentation();
  widgetHLayout->addWidget(helpSearchEngine->queryWidget());
  widgetHLayout->addWidget(helpSearchEngine->resultWidget());
  QWidget *widget = new QWidget;
  widget->setLayout(widgetHLayout);
  tabWidget->addTab(widget, "");

  QSplitter *horizSplitter = new QSplitter(Qt::Horizontal);
  mainVLayout->addWidget(horizSplitter);
  horizSplitter->insertWidget(0, tabWidget);

  QFile file(documentationFileName);
  bool opened = file.open(QFile::ReadOnly | QFile::Text);
  Q_UNUSED(opened);
  QDomDocument xmlDocument;
  xmlDocument.setContent(&file);
  file.close();
  helpBrowser =  new HelpBrowser(helpEngine);
  connect(helpEngine->contentWidget(), SIGNAL(linkActivated(QUrl)), helpBrowser, SLOT(setSource(QUrl)));
//  connect(helpEngine->indexWidget(), SIGNAL(linkActivated(QUrl, QString)), helpBrowser, SLOT(setSource(QUrl)));
  connect(helpSearchEngine->resultWidget(), SIGNAL(requestShowLink(QUrl)), helpBrowser, SLOT(setSource(QUrl)));
  horizSplitter->insertWidget(1, helpBrowser);
  helpBrowser->setSource(QUrl("qthelp://"
                              + xmlDocument.firstChildElement("QtHelpProject").firstChildElement("namespace").text()
                              + "/"
                              + xmlDocument.firstChildElement("QtHelpProject").firstChildElement("virtualFolder").text()
                              + "/index.html"));
  retranslateUI();
  widMain->setLayout(mainVLayout);
  setWidget(widMain);
}

void DHelpViewer::retranslateUI()
{
  setWindowTitle(tr("Help Viewer"));
  setObjectName(windowTitle());
  dTitleLabel->setText(windowTitle());
  tabWidget->setTabText(0, tr("Contents"));
  tabWidget->setTabText(1, tr("Index"));
  tabWidget->setTabText(2, tr("Search"));
}

void DHelpViewer::helpSearchEngineSearchSlot()
{
  helpSearchEngine->search(helpSearchEngine->queryWidget()->searchInput());
}

HelpBrowser::HelpBrowser(QHelpEngine *helpEngine, QWidget* parent)
{
  this->helpEngine = helpEngine;
  this->setParent(parent);
}

QVariant HelpBrowser::loadResource(int type, const QUrl &name)
{
  if (name.scheme() == "qthelp")
    return QVariant(helpEngine->fileData(name));
  else
    return QTextBrowser::loadResource(type, name);
}
