/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QGridLayout>
//#include <QUrl>
//#include <QQuickWidget>
//#include <QQmlApplicationEngine>
//#include <QQmlContext>
#include <QTimer>
//#include <QFile>
#include <QPieSeries>
#include <QChart>
// #include <QChartView>
#include <QMessageBox>
#include <QBrush>
#include <QSplineSeries>
#include <QValueAxis>
#include <QApplication>
#include <QToolTip>
#include <QPieLegendMarker>
#include <QPushButton>
#include <QLegendMarker>

#include "ddashboard.h"
#include "dtitlelabel.h"
#include "dicon.h"
#include "dchartview.h"

#include <QDebug>
//#include <QTime>

//DDashboard::DDashboard(DBMS *serverConnection)
//{
//  setWindowTitle(tr("Dashboard"));
//  setObjectName(windowTitle());
//  this->serverConnection = serverConnection;
//  result = new QList<QStringList>;

////  setWindowIcon((reportType == ReportTypes::PlainText ? DIcon::TextEditor() : DIcon::GraphicsCharts()));
//  QVBoxLayout *mainVLayout = new QVBoxLayout;
//  mainVLayout->setContentsMargins(3, 0, 3, 0);
////  mainVLayout->addWidget(new DTitleLabel(windowTitle()));

//  qTimer = new QTimer(this);
//  connect(qTimer, SIGNAL(timeout()), this, SLOT(reloadData()));
////  qTimer->setInterval(1000 * settings.value("Monitoring/RefreshRate", 1).toInt());
//  qTimer->setInterval(1000 * 1);
//  qTimer->start();

//  QFile::copy(":/qml/ddashboard/main.qml", StaticFunctions::workingDirectory() + "main.qml");
//  widMain = new QQuickWidget(this);
//  reloadData();
//  widMain->setSource(QUrl::fromLocalFile(StaticFunctions::workingDirectory() + "main.qml"));
//  widMain->setResizeMode(QQuickWidget::SizeRootObjectToView);

//  widMain->setLayout(mainVLayout);
//  setWidget(widMain);
//}

//void DDashboard::reloadData()
//{
//  result = serverConnection->runQuery("SELECT `VARIABLE_NAME`, `VARIABLE_VALUE` FROM "
//                                      + serverConnection->getGlobalStatusTable()
//                                      + " WHERE `VARIABLE_NAME` IN ('COM_DELETE', 'COM_INSERT', 'COM_SELECT', 'COM_UPDATE', 'COM_ROLLBACK')");
//  result->takeLast(); //Remove the "Affected rows" line.

//  widMain->rootContext()->setContextProperty("valorPorParametro1", QTime::currentTime());
//  widMain->rootContext()->setContextProperty("COM_DELETE", result->at(0).at(1).toFloat());
//  widMain->rootContext()->setContextProperty("COM_INSERT", result->at(1).at(1).toFloat());
//  widMain->rootContext()->setContextProperty("COM_SELECT", result->at(2).at(1).toFloat());
//  widMain->rootContext()->setContextProperty("COM_UPDATE", result->at(3).at(1).toFloat());
//  widMain->rootContext()->setContextProperty("COM_ROLLBACK", result->at(4).at(1).toFloat());
//}

DDashboard::DDashboard(DBMS *serverConnection)
{
  this->serverConnection = serverConnection;

  result = serverConnection->runQuery("SHOW VARIABLES LIKE 'performance_schema'");
  result->takeLast(); //Remove the "Affected rows" line.

  if (result->at(0).at(1) == "ON") {
//    QApplication::setOverrideCursor(Qt::WaitCursor);
    oneThreadIsRunning = false;
    setWindowIcon(DIcon::Dashboard());
    dTitleLabel = new DTitleLabel;
    result = new QList<QStringList>;
    mainGridLayout = new QGridLayout;
    mainGridLayout->addWidget(dTitleLabel, 0, 0);

    changeViewPushButton = new QPushButton;
    connect(changeViewPushButton, SIGNAL(clicked()), this, SLOT(changeViewPushButtonClicked()));
    changeViewPushButton->setIcon(DIcon::Dashboard());
    changeViewPushButton->setCheckable(true);
    changeViewPushButton->setFixedSize(changeViewPushButton->minimumSizeHint());
    mainGridLayout->addWidget(changeViewPushButton, 0, 1);

    tickCount = 15;

    widCharts1 = new QWidget;
    QGridLayout *widCharts1GridLayout = new QGridLayout;
    //widCharts1GridLayout->setSizeConstraint(QLayout::SetFixedSize);
    widCharts1->setLayout(widCharts1GridLayout);

    //First group of charts
    userPieSeries = new QPieSeries();
    userPieSeries->setObjectName("userPieSeries");
    connect(userPieSeries, SIGNAL(clicked(QPieSlice*)), this, SLOT(handleSliceClicked(QPieSlice*)));
    connect(userPieSeries, SIGNAL(hovered(QPieSlice*,bool)), this, SLOT(handleSliceHovered(QPieSlice*,bool)));
    userChart = new QChart();
    userChart->setAnimationOptions(QChart::AllAnimations);
    userChart->legend()->setAlignment(Qt::AlignLeft);
    userChart->legend()->show();
    userChartView = new DChartView();
    connect(userChartView, SIGNAL(mouseDoubleClickEventEmited(QString)), this, SLOT(mouseDoubleClickEventEmitedSlot(QString)));
    userChartView->setObjectName("userPieSeries");
    userChartView->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);
    userChartView->setRenderHint(QPainter::Antialiasing, true);
    userChart->addSeries(userPieSeries);
    userChartView->setChart(userChart);
    widCharts1GridLayout->addWidget(userChartView, 0, 0);

    databasesSizesPieSeries = new QPieSeries();
    databasesSizesPieSeries->setObjectName("databasesSizesPieSeries");
    connect(databasesSizesPieSeries, SIGNAL(clicked(QPieSlice*)), this, SLOT(handleSliceClicked(QPieSlice*)));
    connect(databasesSizesPieSeries, SIGNAL(hovered(QPieSlice*,bool)), this, SLOT(handleSliceHovered(QPieSlice*,bool)));
    databasesSizesChart = new QChart();
    databasesSizesChart->setAnimationOptions(QChart::AllAnimations);
    databasesSizesChart->legend()->show();
    databasesSizesChart->legend()->setAlignment(Qt::AlignRight);
    databasesSizesChartView = new DChartView();
    connect(databasesSizesChartView, SIGNAL(mouseDoubleClickEventEmited(QString)), this, SLOT(mouseDoubleClickEventEmitedSlot(QString)));
    databasesSizesChartView->setObjectName("databasesSizesPieSeries");
    databasesSizesChartView->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);
    databasesSizesChartView->setRenderHint(QPainter::Antialiasing, true);
    databasesSizesChart->addSeries(databasesSizesPieSeries);
    databasesSizesChartView->setChart(databasesSizesChart);
    widCharts1GridLayout->addWidget(databasesSizesChartView, 0, 1);

    bytesReceivedSplineSeries = new QSplineSeries();
    bytesSentSplineSeries = new QSplineSeries();
    bytesSentOrReceivedChart = new QChart();
//    bytesSentOrReceivedChart->legend()->hide();
    bytesSentOrReceivedChartView = new DChartView();
    connect(bytesSentOrReceivedChartView, SIGNAL(mouseDoubleClickEventEmited(QString)), this, SLOT(mouseDoubleClickEventEmitedSlot(QString)));
    bytesSentOrReceivedChartView->setObjectName("bytesReceived&Sent");
    bytesSentOrReceivedChartView->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);
    bytesSentOrReceivedChartView->setRenderHint(QPainter::Antialiasing, true);
    bytesSentOrReceivedChart->addSeries(bytesReceivedSplineSeries);
    bytesSentOrReceivedChart->addSeries(bytesSentSplineSeries);
    bytesSentOrReceivedChartView->setChart(bytesSentOrReceivedChart);
    result = serverConnection->runQuery("SELECT * FROM `information_schema`.`GLOBAL_STATUS` WHERE `VARIABLE_NAME` IN ('BYTES_RECEIVED', 'BYTES_SENT')");
    result->takeLast(); //Remove the "Affected rows" line.
    bytesSentLast = result->at(1).at(1).toULongLong() / 1024;
    bytesSentCurrent = bytesSentLast;
    bytesReceivedLast = result->at(0).at(1).toULongLong() / 1024;
    bytesReceivedCurrent = bytesReceivedLast;
    widCharts1GridLayout->addWidget(bytesSentOrReceivedChartView, 1, 0);

    queriesSplineSeries = new QSplineSeries();
    queriesChart = new QChart();
    queriesChart->legend()->hide();
    queriesChartView = new DChartView();
    connect(queriesChartView, SIGNAL(mouseDoubleClickEventEmited(QString)), this, SLOT(mouseDoubleClickEventEmitedSlot(QString)));
    queriesChartView->setObjectName("queriesSplineSeries");
    queriesChartView->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);
    queriesChartView->setRenderHint(QPainter::Antialiasing, true);
    queriesChart->addSeries(queriesSplineSeries);
    queriesChartView->setChart(queriesChart);
    result = serverConnection->runQuery("SELECT `VARIABLE_VALUE` FROM `information_schema`.`GLOBAL_STATUS` WHERE `VARIABLE_NAME` = 'Queries'");
    result->takeLast(); //Remove the "Affected rows" line.
    queriesLast = result->at(0).at(0).toULongLong();
    queriesCurrent = queriesLast;
    widCharts1GridLayout->addWidget(queriesChartView, 1, 1);

    widCharts2 = new QWidget;
    widCharts2->setVisible(false);
    QGridLayout *widCharts2GridLayout = new QGridLayout;
    widCharts2->setLayout(widCharts2GridLayout);

    //Second group of charts
    memoryPieSeries = new QPieSeries();
    memoryPieSeries->setObjectName("memoryPieSeries");
    connect(memoryPieSeries, SIGNAL(clicked(QPieSlice*)), this, SLOT(handleSliceClicked(QPieSlice*)));
    connect(memoryPieSeries, SIGNAL(hovered(QPieSlice*,bool)), this, SLOT(handleSliceHovered(QPieSlice*,bool)));
    memoryChart = new QChart();
    memoryChart->setAnimationOptions(QChart::AllAnimations);
    memoryChart->legend()->setAlignment(Qt::AlignBottom);
    memoryChart->legend()->show();
    memoryChartView = new DChartView();
    connect(memoryChartView, SIGNAL(mouseDoubleClickEventEmited(QString)), this, SLOT(mouseDoubleClickEventEmitedSlot(QString)));
    memoryChartView->setObjectName("memoryPieSeries");
    memoryChartView->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);
    memoryChartView->setRenderHint(QPainter::Antialiasing, true);
    memoryChart->addSeries(memoryPieSeries);
    memoryChartView->setChart(memoryChart);
    widCharts2GridLayout->addWidget(memoryChartView, 0, 0);

    loadAveragePieSeries = new QPieSeries();
    loadAveragePieSeries->setObjectName("loadAveragePieSeries");
    connect(loadAveragePieSeries, SIGNAL(clicked(QPieSlice*)), this, SLOT(handleSliceClicked(QPieSlice*)));
    connect(loadAveragePieSeries, SIGNAL(hovered(QPieSlice*,bool)), this, SLOT(handleSliceHovered(QPieSlice*,bool)));
    loadAverageChart = new QChart();
    loadAverageChart->setAnimationOptions(QChart::AllAnimations);
    loadAverageChart->legend()->setAlignment(Qt::AlignBottom);
    loadAverageChart->legend()->show();
    loadAverageChartView = new DChartView();
    connect(loadAverageChartView, SIGNAL(mouseDoubleClickEventEmited(QString)), this, SLOT(mouseDoubleClickEventEmitedSlot(QString)));
    loadAverageChartView->setObjectName("loadAveragePieSeries");
    loadAverageChartView->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);
    loadAverageChartView->setRenderHint(QPainter::Antialiasing, true);
    loadAverageChart->addSeries(loadAveragePieSeries);
    loadAverageChartView->setChart(loadAverageChart);
    widCharts2GridLayout->addWidget(loadAverageChartView, 0, 1);

    mainGridLayout->addWidget(widCharts1, 1, 0, 1, 2);
    mainGridLayout->addWidget(widCharts2, 1, 0, 1, 2);
    widMain = new QWidget;
    widMain->setLayout(mainGridLayout);
    setWidget(widMain);

    retranslateUI();

    qTimer100Seconds = new QTimer(this);
    qTimer100Seconds->setInterval(1000 * 100);
    qTimer100Seconds->start();
    connect(qTimer100Seconds, SIGNAL(timeout()), this, SLOT(reloadData100Seconds()));
    QTimer::singleShot(0, this, SLOT(reloadData100Seconds()));
//    reloadData100Seconds();

    qTimer10Seconds = new QTimer(this);
    qTimer10Seconds->setInterval(1000 * 10);
    qTimer10Seconds->start();
    connect(qTimer10Seconds, SIGNAL(timeout()), this, SLOT(reloadData10Seconds()));
    QTimer::singleShot(0, this, SLOT(reloadData10Seconds()));
//    reloadData10Seconds();

    qTimer1Second = new QTimer(this);
    qTimer1Second->setInterval(1000 * 1);
    qTimer1Second->start();
    connect(qTimer1Second, SIGNAL(timeout()), this, SLOT(reloadData1Second()));
    QTimer::singleShot(0, this, SLOT(reloadData1Second()));
//    reloadData1Second();

//    QApplication::restoreOverrideCursor();
  } else {
    QString message = tr("performance_schema is not enabled on this server");
    QMessageBox::information(this, message, message);
  }
}

void DDashboard::retranslateUI()
{
  setWindowTitle(tr("Dashboard"));
  setObjectName(windowTitle());
  dTitleLabel->setText(windowTitle());
  dTitleLabel->setToolTip(dTitleLabel->text());
  userChart->setTitle(tr("Users and Connections"));
  databasesSizesChart->setTitle(tr("The five largest databases"));
  bytesSentOrReceivedChart->setTitle(tr("Kilobytes sent and received"));
  bytesReceivedSplineSeries->setName(tr("Received"));
  bytesSentSplineSeries->setName(tr("Sent"));
  queriesChart->setTitle(tr("Queries"));
  queriesSplineSeries->setName(tr("Queries"));
  memoryChart->setTitle(tr("Free and used memory in megabytes"));
  loadAverageChart->setTitle(tr("Load average"));
}

DDashboard::~DDashboard()
{
}

void DDashboard::reloadData100Seconds()
{
  if (widCharts1->isVisible()) {
    if (!oneThreadIsRunning) {
      oneThreadIsRunning = true;
      threadedQueryExecution = new ThreadedQueryExecution(this->serverConnection->getConnectionParameters(), "SELECT `TABLE_SCHEMA`, CAST(SUM(`DATA_LENGTH` + `INDEX_LENGTH`) / 1024 / 1024 AS UNSIGNED) AS `Size` FROM `information_schema`.`TABLES` GROUP BY `TABLE_SCHEMA` ORDER BY `Size` DESC LIMIT 5");
      threadedQueryExecution->setOnlyExecuteSafeStatements(true);
      threadedQueryExecution->setOutputType("QList<QStringList>");
      threadedQueryExecution->setSaveToFile(false);
      threadedQueryExecution->setShowNewLines(false);
      connect(threadedQueryExecution, SIGNAL(listResultReady(QList<QStringList>*)), this, SLOT(handleResultsOfThreadedQueryExecution(QList<QStringList>*)));
      connect(threadedQueryExecution, SIGNAL(finished()), this, SLOT(handleFinishedOfThreadedQueryExecution()));
      threadedQueryExecution->start();
    }
  }
  if (widCharts2->isVisible()) {
    QList<QLegendMarker *> markers;
    memoryPieSeries->clear();
    result = serverConnection->runQuery("SELECT COUNT(*) AS `Total` FROM `mysql`.`func` WHERE `name` IN ('Caliope_OS_Total_Memory', 'Caliope_OS_Free_Memory')");
    result->takeLast(); //Remove the "Affected rows" line.
    if (result->at(0).at(0) == "2") {
      result = serverConnection->runQuery("SELECT (`Caliope_OS_Free_Memory`() / 1024 / 1024) AS `Free_Memory`, ((`Caliope_OS_Total_Memory`() - `Caliope_OS_Free_Memory`()) / 1024 / 1024) AS `Used_Memory`");
      result->takeLast(); //Remove the "Affected rows" line.
      memoryPieSeries->append(tr("Free memory: %1").arg(result->at(0).at(0)), result->at(0).at(0).toDouble());
      memoryPieSeries->append(tr("Used memory: %1").arg(result->at(0).at(1)), result->at(0).at(1).toDouble());
      memoryPieSeries->setLabelsVisible();
      memoryPieSeries->setHoleSize(0.25);
      markers = memoryChart->legend()->markers();
      for (QLegendMarker *marker : markers) {
        QObject::disconnect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
        QObject::connect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
      }
    }
    loadAveragePieSeries->clear();
    result = serverConnection->runQuery("SELECT COUNT(*) AS `Total` FROM `mysql`.`func` WHERE `name` IN ('Caliope_OS_CPUTotal', 'Caliope_OS_LastLoadAverage')");
    result->takeLast(); //Remove the "Affected rows" line.
    if (result->at(0).at(0) == "2") {
      result = serverConnection->runQuery("SELECT ((`Caliope_OS_CPUTotal`() - `Caliope_OS_LastLoadAverage`()) * 100) / `Caliope_OS_CPUTotal`() AS `FreePercentage`, (`Caliope_OS_LastLoadAverage`() * 100) / `Caliope_OS_CPUTotal`() AS `LoadPercentage`");
      result->takeLast(); //Remove the "Affected rows" line.
      loadAveragePieSeries->append(tr("Free percentage: %1").arg(result->at(0).at(0)), result->at(0).at(0).toDouble());
      loadAveragePieSeries->append(tr("Load percentage: %1").arg(result->at(0).at(1)), result->at(0).at(1).toDouble());
      loadAveragePieSeries->setLabelsVisible();
      loadAveragePieSeries->setHoleSize(0.25);
      markers = loadAverageChart->legend()->markers();
      for (QLegendMarker *marker : markers) {
        QObject::disconnect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
        QObject::connect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
      }
    }
  }
}

void DDashboard::reloadData10Seconds()
{
  if (widCharts1->isVisible()) {
    userPieSeries->clear();
    result = serverConnection->runQuery("SELECT `USER`, `CURRENT_CONNECTIONS` FROM `performance_schema`.`users` WHERE `CURRENT_CONNECTIONS` > 0 AND `USER` IS NOT NULL ORDER BY `CURRENT_CONNECTIONS` DESC");
    result->takeLast(); //Remove the "Affected rows" line.
    for (int counter = 0; counter < result->count(); counter++) {
      userPieSeries->append(result->at(counter).at(0) + ": " + result->at(counter).at(1), result->at(counter).at(1).toUInt());
    }
    userPieSeries->setLabelsVisible();
    userPieSeries->setHoleSize(0.25);
    QList<QLegendMarker *> markers = userChart->legend()->markers();
    for (QLegendMarker *marker : markers) {
      QObject::disconnect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
      QObject::connect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
    }
  }
}

void DDashboard::reloadData1Second()
{
  if (widCharts1->isVisible()) {
    result = serverConnection->runQuery("SELECT * FROM `information_schema`.`GLOBAL_STATUS` WHERE `VARIABLE_NAME` IN ('BYTES_RECEIVED', 'BYTES_SENT')");
    result->takeLast(); //Remove the "Affected rows" line.
    bytesSentLast = bytesSentCurrent;
    bytesSentCurrent = result->at(1).at(1).toULongLong() / 1024;
    bytesReceivedLast = bytesReceivedCurrent;
    bytesReceivedCurrent = result->at(0).at(1).toULongLong() / 1024;
    if (bytesSentLinePoints.count() > tickCount)
      bytesSentLinePoints.takeFirst();
    bytesSentLinePoints.append(QPointF(bytesSentSplineSeriesCounter, bytesSentCurrent - bytesSentLast));
    bytesSentSplineSeries->clear();
    bytesSentSplineSeries->append(bytesSentLinePoints);
    if (bytesReceivedLinePoints.count() > tickCount)
      bytesReceivedLinePoints.takeFirst();
    bytesReceivedLinePoints.append(QPointF(bytesSentSplineSeriesCounter++, bytesReceivedCurrent - bytesReceivedLast));
    bytesReceivedSplineSeries->clear();
    bytesReceivedSplineSeries->append(bytesReceivedLinePoints);
    bytesSentOrReceivedChart->removeSeries(bytesSentSplineSeries);
    bytesSentOrReceivedChart->addSeries(bytesSentSplineSeries);
    bytesSentOrReceivedChart->removeSeries(bytesReceivedSplineSeries);
    bytesSentOrReceivedChart->addSeries(bytesReceivedSplineSeries);
    bytesSentOrReceivedChart->createDefaultAxes();
    bytesSentOrReceivedChart->removeAxis(bytesSentOrReceivedChart->axes(Qt::Horizontal).at(0));

    result = serverConnection->runQuery("SELECT `VARIABLE_VALUE` FROM `information_schema`.`GLOBAL_STATUS` WHERE `VARIABLE_NAME` = 'Queries'");
    result->takeLast(); //Remove the "Affected rows" line.
    queriesLast = queriesCurrent;
    queriesCurrent = result->at(0).at(0).toULongLong();
    if (queriesPoints.count() > tickCount)
      queriesPoints.takeFirst();
    queriesPoints.append(QPointF(queriesSplineSeriesCounter++, queriesCurrent - queriesLast));
    queriesSplineSeries->clear();
    queriesSplineSeries->append(queriesPoints);
    if (queriesPoints.count() > tickCount)
      queriesPoints.takeFirst();
    queriesChart->removeSeries(queriesSplineSeries);
    queriesChart->addSeries(queriesSplineSeries);
    queriesChart->createDefaultAxes();
    queriesChart->removeAxis(queriesChart->axes(Qt::Horizontal).at(0));
  }
}

void DDashboard::handleSliceClicked(QPieSlice *slice)
{
  slice->setExploded(!slice->isExploded());
  if (slice->series()->objectName() == "userPieSeries") {
    if (slice->isExploded()) {
      qTimer10Seconds->stop();
    } else {
      qTimer10Seconds->start();
    }
  }
//  if (slice->series()->objectName() == "databasesSizesPieSeries"
//      || slice->series()->objectName() == "memoryPieSeries"
//      ) {
//    if (slice->isExploded()) {
//      qTimer100Seconds->stop();
//    } else {
//      qTimer100Seconds->start();
//    }
//  }
}

void DDashboard::handleSliceHovered(QPieSlice *slice, bool state)
{
  QToolTip::showText(QCursor::pos(), QString("%1").arg(slice->value()));
  if (state) {
    QBrush newSliceBrush = slice->brush();
    originalSliceBrush = newSliceBrush;
    newSliceBrush.setColor(newSliceBrush.color().darker());
    slice->setBrush(newSliceBrush);
  } else {
    slice->setBrush(originalSliceBrush);
  }
}

void DDashboard::handleResultsOfThreadedQueryExecution(QList<QStringList> *result)
{
  databasesSizesPieSeries->clear();
  result->takeLast(); //Remove the "Affected rows" line.
  for (int counter = 0; counter < result->count(); counter++) {
    databasesSizesPieSeries->append(result->at(counter).at(0), result->at(counter).at(1).toUInt());
  }
  databasesSizesPieSeries->setLabelsVisible();
  databasesSizesPieSeries->setHoleSize(0.25);
  QList<QLegendMarker *> markers = databasesSizesChart->legend()->markers();
  for (QLegendMarker *marker : markers) {
    QObject::disconnect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
    QObject::connect(marker, &QLegendMarker::clicked, this, &DDashboard::userChartLegendMarkerClicked);
    // connect(userChart->legend()->markers(), SIGNAL(clicked()), this, SLOT(userChartLegendMarkerClicked));
  }
  oneThreadIsRunning = false;
}

void DDashboard::userChartLegendMarkerClicked()
{
  QPieLegendMarker* marker = qobject_cast<QPieLegendMarker*> (sender());
  QPieSlice *slice = marker->slice();

  slice->setExploded(!slice->isExploded());
  if (slice->series()->objectName() == "userPieSeries") {
    if (slice->isExploded()) {
      qTimer10Seconds->stop();
    } else {
      qTimer10Seconds->start();
    }
  }
}

void DDashboard::changeViewPushButtonClicked()
{
  if (!(serverConnection->runQuerySingleColumn("SELECT `name` FROM `mysql`.`func` WHERE name IN ('Caliope_OS_Total_Memory', 'Caliope_OS_Free_Memory') AND `dl` LIKE 'Caliope_Plugin%'")
      .count() == 2)) {
    QMessageBox messageBox;
    QString message = tr("Calíope_Plugin is requiered to show the show this charts. See Help->Calíope plugin for more information.");
    messageBox.setText(message);
    messageBox.exec();
    changeViewPushButton->setChecked(false);
    return;
  }
  widCharts1->setVisible(!changeViewPushButton->isChecked());
  widCharts2->setVisible(changeViewPushButton->isChecked());
  QTimer::singleShot(0, this, SLOT(reloadData100Seconds()));
}

void DDashboard::handleFinishedOfThreadedQueryExecution()
{
  threadedQueryExecution->~ThreadedQueryExecution();
}

void DDashboard::mouseDoubleClickEventEmitedSlot(QString objectName)
{
  if (!changeViewPushButton->isChecked()) {
    if (objectName == "userPieSeries") {
      databasesSizesChartView->setVisible(!databasesSizesChartView->isVisible());
      bytesSentOrReceivedChartView->setVisible(!bytesSentOrReceivedChartView->isVisible());
      queriesChartView->setVisible(!queriesChartView->isVisible());
    }
    if (objectName == "databasesSizesPieSeries") {
      userChartView->setVisible(!userChartView->isVisible());
      bytesSentOrReceivedChartView->setVisible(!bytesSentOrReceivedChartView->isVisible());
      queriesChartView->setVisible(!queriesChartView->isVisible());
    }
    if (objectName == "bytesReceived&Sent") {
      userChartView->setVisible(!userChartView->isVisible());
      databasesSizesChartView->setVisible(!databasesSizesChartView->isVisible());
      queriesChartView->setVisible(!queriesChartView->isVisible());
    }
    if (objectName == "queriesSplineSeries") {
      userChartView->setVisible(!userChartView->isVisible());
      databasesSizesChartView->setVisible(!databasesSizesChartView->isVisible());
      bytesSentOrReceivedChartView->setVisible(!bytesSentOrReceivedChartView->isVisible());
    }
  }
  if (changeViewPushButton->isChecked()) {
    if (objectName == "loadAveragePieSeries") {
      memoryChartView->setVisible(!memoryChartView->isVisible());
    }
    if (objectName == "memoryPieSeries") {
      loadAverageChartView->setVisible(!loadAverageChartView->isVisible());
    }
  }
}
