/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef DCHARTVIEW_H
#define DCHARTVIEW_H

#include <QChartView>
#include <QObject>

/**
 * @brief The DChartView class provides a standalone widget for displaying charts.
 *
 * This class extends QChartView to provide custom event handling, specifically
 * allowing the detection and signaling of mouse double-click events on the chart.
 */
class DChartView : public QChartView
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the DChartView widget.
   */
  DChartView();

protected:
  /**
   * @brief Handles mouse double-click events.
   *
   * Reimplemented from QWidget/QChartView to capture double-clicks.
   *
   * @param event Pointer to the QMouseEvent containing details about the event.
   */
  void mouseDoubleClickEvent(QMouseEvent *event);

signals:
  /**
   * @brief Signal emitted when the chart view is double-clicked.
   * @param objectName The name of the object associated with the event (if applicable).
   */
  void mouseDoubleClickEventEmited(QString objectName);
};

#endif // DCHARTVIEW_H
