/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef COMMITDIALOG_H
#define COMMITDIALOG_H

#include <QDialog>

#include "dsettings.h"

class QDialogButtonBox;
class QLineEdit;
class BaseTextEditor;

/**
 * @brief The CommitDialog class provides a user interface for version control commits.
 *
 * This dialog allows the user to enter their credentials (username and password)
 * and a log message describing the changes before performing a commit operation
 * on a specific file.
 */
class CommitDialog : public QDialog
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the CommitDialog.
   * @param file The path or name of the file pending commit.
   */
  CommitDialog(QString file);

  /**
   * @brief Retrieves the data entered by the user.
   *
   * This typically includes the username, password, and the commit message text.
   *
   * @return A QStringList containing the collected input values.
   */
  QStringList getValues();

private:
  QDialogButtonBox *buttonBox;
  QLineEdit *lineEditUser;
  QLineEdit *lineEditPassword;
  DSettings settings;
  BaseTextEditor *commitLog;
};

#endif // COMMITDIALOG_H
