/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef BASESVNLOG_H
#define BASESVNLOG_H

#include <QWidget>

/**
 * @brief The BaseSVNLog class provides a widget interface for SVN log operations.
 *
 * This class inherits from QWidget and is designed to handle or display
 * Subversion (SVN) log history associated with a specific file.
 */
class BaseSVNLog : public QWidget
{
public:
  /**
   * @brief Constructs the BaseSVNLog widget.
   * @param file The path to the file for which the SVN log will be retrieved.
   */
  BaseSVNLog(QString file);
};

#endif // BASESVNLOG_H
