/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef BASEDIFFFILE_H
#define BASEDIFFFILE_H

#include <QWidget>

/**
 * @brief The BaseDiffFile class represents a widget for file comparison operations.
 *
 * This class inherits from QWidget and is designed to handle or display
 * information related to a specific file used in a diff process.
 */
class BaseDiffFile : public QWidget
{
  Q_OBJECT

public:
  /**
   * @brief Constructs the BaseDiffFile widget.
   * @param file The path or name of the file associated with this widget.
   */
  BaseDiffFile(QString file);
};

#endif // BASEDIFFFILE_H
