/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#ifndef APPLICATIONTHEME_H
#define APPLICATIONTHEME_H

#include <QWidget>

class QPlainTextEdit;
class GeneralHighlighter;
class QPushButton;
class QComboBox;

/**
 * @brief The ApplicationTheme class provides a widget to manage application themes.
 *
 * This class allows the user to select, edit, copy, remove, import, and export
 * syntax highlighting themes. It includes a preview area to visualize the
 * current theme settings.
 */
class ApplicationTheme : public QWidget
{
  Q_OBJECT

public:
  /**
   * @brief Constructs a new ApplicationTheme widget.
   */
  ApplicationTheme();

  /**
   * @brief Retranslates the UI text strings.
   *
   * This method should be called when the application language changes to
   * update the texts of buttons and labels dynamically.
   */
  void retranslateUI();

  /**
   * @brief Retrieves the foreground brush used for operators.
   * @return A QBrush containing the color/style for operator characters.
   */
  static QBrush operatorsForeground();

  /**
   * @brief Retrieves the foreground brush used for integers.
   * @return A QBrush containing the color/style for integer numbers.
   */
  static QBrush integersForeground();

private:
  /** @brief Widget used to preview the syntax highlighting theme. */
  QPlainTextEdit *themePlainTextEdit;

  /** @brief Helper class to apply highlighting rules in the preview editor. */
  GeneralHighlighter *generalHighlighter;

  /** @brief Button to copy the currently selected theme to a new one. */
  QPushButton *copyPushButton;

  /** @brief Button to enable editing mode for the selected theme. */
  QPushButton *editPushButton;

  /** @brief Button to delete the selected theme. */
  QPushButton *removePushButton;

  /** @brief Button to export the current theme settings to a file. */
  QPushButton *exportPushButton;

  /** @brief Button to import theme settings from a file. */
  QPushButton *importPushButton;

  /** @brief Dropdown list to select among available themes/settings. */
  QComboBox *settingsListComboBox;
};

#endif // APPLICATIONTHEME_H
