/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QTextCharFormat>
#include <QPlainTextEdit>
#include <QVBoxLayout>
#include <QPushButton>
#include <QLabel>
#include <QComboBox>

#include "applicationtheme.h"
#include "generalhighlighter.h"
#include "editortypes.h"
#include "dicon.h"

ApplicationTheme::ApplicationTheme()
{
  themePlainTextEdit = new QPlainTextEdit("CREATE TABLE `NewTable` ("
                                        "\n  `Field01` VARCHAR(15) COLLATE utf8_spanish_ci NOT NULL COMMENT 'Comment for Field01',"
                                        "\n  `Field02` ENUM('Enum1', 'Enum2') COLLATE utf8_spanish_ci NOT NULL DEFAULT 'Enum1' COMMENT 'Comment for Field02',"
                                        "\n  `Field03` DATE NOT NULL COMMENT 'Comment for Field03'"
                                        "\n  `Image` BLOB  COMMENT 'Comment for Image',"
                                        "\n  `LastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Comment for LastUpdate',"
                                        "\n  PRIMARY KEY (`Field01`),"
                                        "\n  KEY `Idx1`(`Field02`)"
                                        "\n) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_spanish_ci COMMENT = 'Foo comment';\n");
  generalHighlighter = new GeneralHighlighter(themePlainTextEdit->document(), EditorTypes::SQLQuery);

  QHBoxLayout *groupBoxHLayout = new QHBoxLayout;
  copyPushButton = new QPushButton(DIcon::Copy(), tr("Copy"), this);
  editPushButton = new QPushButton(DIcon::Export(), tr("Edit"), this);
  removePushButton = new QPushButton(DIcon::Delete(), tr("Remove"), this);
  exportPushButton = new QPushButton(DIcon::Export(), tr("Export"), this);
  importPushButton = new QPushButton(DIcon::Copy(), tr("Import"), this);
  settingsListComboBox = new QComboBox();
  groupBoxHLayout->addWidget(new QLabel(tr("Current settings:")));
  groupBoxHLayout->addWidget(settingsListComboBox);
  groupBoxHLayout->addWidget(copyPushButton);
  groupBoxHLayout->addWidget(editPushButton);
  groupBoxHLayout->addWidget(removePushButton);
  groupBoxHLayout->addWidget(exportPushButton);
  groupBoxHLayout->addWidget(importPushButton);
  retranslateUI();
  QVBoxLayout *mainVLayout = new QVBoxLayout;
  mainVLayout->addLayout(groupBoxHLayout);
  mainVLayout->addWidget(themePlainTextEdit);
  setLayout(mainVLayout);
}

void ApplicationTheme::retranslateUI()
{
  copyPushButton->setText(tr("Copy"));
  copyPushButton->setToolTip(copyPushButton->text());
  editPushButton->setText(tr("Edit"));
  editPushButton->setToolTip(editPushButton->text());
  removePushButton->setText(tr("Remove"));
  removePushButton->setToolTip(removePushButton->text());
  exportPushButton->setText(tr("Export"));
  exportPushButton->setToolTip(exportPushButton->text());
  importPushButton->setText(tr("Import"));
  importPushButton->setToolTip(importPushButton->text());
}

QBrush ApplicationTheme::operatorsForeground()
{
  return Qt::red;
}

QBrush ApplicationTheme::integersForeground()
{
  return Qt::red;
}
