// https://fromdual.com/mysql-plugins-and-udfs

// https://mariadb.com/kb/en/creating-user-defined-functions/
// https://mariadb.com/kb/en/user-defined-functions-calling-sequences/

//How to compile on Linux
// sudo service mariadb stop; gcc -I/home/david/caliope/mariadb/include -fPIC -shared -o Caliope_Plugin.so Caliope_Plugin.c; sudo rm /usr/lib/mysql/plugin/Caliope_Plugin.so; sudo cp Caliope_Plugin.so /usr/lib/mysql/plugin/; sudo service mariadb start

//How to compile on Windows ¡¡¡¡¡NOT WORKING!!!!!

//C:\Qt\Tools\mingw1120_64\bin\gcc.exe -c Caliope_Plugin.c
//C:\Qt\Tools\mingw1120_64\bin\ar.exe rcs libCaliope_Plugin.a Caliope_Plugin.o

// SELECT * FROM `mysql`.`func`;
// DROP FUNCTION IF EXISTS `Caliope_OS_Total_Memory`;
// CREATE FUNCTION `Caliope_OS_Total_Memory` RETURNS INT SONAME 'Caliope_Plugin.so';
// SELECT `Caliope_OS_Total_Memory`();

// Simulate the Q_OS_X definitions, uncomment the line corresponding to the operative system
//#define Q_OS_WIN
#define Q_OS_LINUX
//#define Q_OS_MAC

//Operative system
#if defined(Q_OS_WIN)
#include <C:\Users\User\Desktop\Caliope\caliope\mariadb\include\mysql.h>
#include <windows.h>
#elif defined(Q_OS_LINUX)
#include </home/david/caliope/mariadb/include/mysql.h>
#include <sys/sysinfo.h>
#elif defined(Q_OS_MAC)
os = "Mac";
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#define UNUSED(x) (void)(x)

// Caliope_OS_Total_Memory
my_bool Caliope_OS_Total_Memory_init(UDF_INIT *initid,UDF_ARGS *args, char *message) {
  UNUSED(initid);
  UNUSED(args);
  UNUSED(message);
//   if (args->arg_count != 1) {
//     strcpy(message, "Caliope_OS_Total_Memory() can only accept one string argument");
//     return 1;
//   }
//   if (args->arg_type[0] != STRING_RESULT) {
//     strcpy(message, "Caliope_OS_Total_Memory() argument has to be an string");
//     return 1;
//   }
  return 0;
}

void Caliope_OS_Total_Memory_deinit(UDF_INIT *initid) {
  UNUSED(initid);
}

unsigned long int Caliope_OS_Total_Memory(UDF_INIT *initid, UDF_ARGS *args, char *result, unsigned long  *length, char *is_null, char *error)
{
  UNUSED(initid);
  UNUSED(args);
  UNUSED(result);
  UNUSED(length);
  UNUSED(is_null);
  UNUSED(error);
#if defined(Q_OS_WIN)
  MEMORYSTATUSEX status;
  status.dwLength = sizeof (status);
  GlobalMemoryStatusEx (&status);
  return status.ullTotalPhys;
#elif defined(Q_OS_LINUX)
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    fprintf(stderr, "Error retrieving system information: %s\n", strerror(errno));
    return -1;
  }
  return info.totalram;
#elif defined(Q_OS_MAC)
  os = "Mac";
#endif
}
// Caliope_OS_Total_Memory

// Caliope_OS_Free_Memory
my_bool Caliope_OS_Free_Memory_init(UDF_INIT *initid,UDF_ARGS *args, char *message) {
  UNUSED(initid);
  UNUSED(args);
  UNUSED(message);
  return 0;
}

void Caliope_OS_Free_Memory_deinit(UDF_INIT *initid) {
  UNUSED(initid);
}

unsigned long int Caliope_OS_Free_Memory(UDF_INIT *initid, UDF_ARGS *args, char *result, unsigned long  *length, char *is_null, char *error)
{
  UNUSED(initid);
  UNUSED(args);
  UNUSED(result);
  UNUSED(length);
  UNUSED(is_null);
  UNUSED(error);
#if defined(Q_OS_WIN)
  MEMORYSTATUSEX status;
  status.dwLength = sizeof (status);
  GlobalMemoryStatusEx (&status);
  return status.ullAvailPhys;
#elif defined(Q_OS_LINUX)
  struct sysinfo info;
  if (sysinfo(&info) != 0) {
    fprintf(stderr, "Caliope_OS_Free_Memory: Error retrieving system information: %s\n", strerror(errno));
    return -1;
  }
  return info.freeram;
#elif defined(Q_OS_MAC)
  os = "Mac";
#endif
}
// Caliope_OS_Free_Memory

// Caliope_OS_LastLoadAverage
my_bool Caliope_OS_LastLoadAverage_init(UDF_INIT *initid,UDF_ARGS *args, char *message) {
  UNUSED(initid);
  UNUSED(args);
  UNUSED(message);
  return 0;
}

void Caliope_OS_LastLoadAverage_deinit(UDF_INIT *initid) {
  UNUSED(initid);
}

char * Caliope_OS_LastLoadAverage(UDF_INIT *initid, UDF_ARGS *args, char *result, unsigned long  *length, char *is_null, char *error)
{
  UNUSED(initid);
  UNUSED(args);
  UNUSED(result);
  UNUSED(length);
  UNUSED(is_null);
  UNUSED(error);
#if defined(Q_OS_WIN)
#elif defined(Q_OS_LINUX)
  const char *ruta_archivo = "/proc/loadavg";
  FILE *archivo = fopen(ruta_archivo, "r");
  char linea[256];
  fgets(linea, sizeof(linea), archivo);
  fclose(archivo);
  char *primer_espacio = strchr(linea, ' ');
  size_t longitud = primer_espacio - linea;
  char *texto = (char *)malloc((longitud + 1) * sizeof(char));
  strncpy(texto, linea, longitud);
  texto[longitud] = '\0';
  return texto;
#elif defined(Q_OS_MAC)
#endif
}
// Caliope_OS_LastLoadAverage

// Caliope_OS_CPUTotal
my_bool Caliope_OS_CPUTotal_init(UDF_INIT *initid,UDF_ARGS *args, char *message) {
  UNUSED(initid);
  UNUSED(args);
  UNUSED(message);
  return 0;
}

void Caliope_OS_CPUTotal_deinit(UDF_INIT *initid) {
  UNUSED(initid);
}

unsigned int Caliope_OS_CPUTotal(UDF_INIT *initid, UDF_ARGS *args, char *result, unsigned long  *length, char *is_null, char *error)
{
  UNUSED(initid);
  UNUSED(args);
  UNUSED(result);
  UNUSED(length);
  UNUSED(is_null);
  UNUSED(error);
#if defined(Q_OS_WIN)
#elif defined(Q_OS_LINUX)
  const char *ruta_archivo = "/proc/cpuinfo";
  FILE *archivo = fopen(ruta_archivo, "r");
  char linea[256];
  int num_procesadores = 0;
  while (fgets(linea, sizeof(linea), archivo) != NULL) {
    if (strstr(linea, "processor") != NULL) {
      num_procesadores++;
    }
  }
  fclose(archivo);
  return num_procesadores;
#elif defined(Q_OS_MAC)
#endif
}
// Caliope_OS_LastLoadAverage
