#!/bin/sh

cd packages/calíope/data

rm -rf plugins
mkdir -p plugins/iconengines
cp $1/plugins/iconengines/libqsvgicon.so plugins/iconengines

mkdir -p plugins/imageformats
cp $1/plugins/imageformats/libqgif.so plugins/imageformats

mkdir -p plugins/platforms
cp $1/plugins/platforms/*.so plugins/platforms

mkdir -p plugins/sqldrivers
cp $1/plugins/sqldrivers/libqsqlite.so plugins/sqldrivers

mkdir -p plugins/platformthemes
cp $1/plugins/platformthemes/*.so plugins/platformthemes

mkdir -p plugins/platforminputcontexts
cp $1/plugins/platforminputcontexts/*.so plugins/platforminputcontexts

mkdir -p plugins/xcbglintegrations
cp $1/plugins/xcbglintegrations/*.so plugins/xcbglintegrations

mkdir -p plugins/wayland-shell-integration
cp $1/plugins/wayland-shell-integration/*.so plugins/wayland-shell-integration

# Se debe agregar la traducción correpondiente, de momento Calíope sólo tiene Español, por eso sólo se importa esa traducción
rm -rf translations
mkdir -p translations
cp $1/translations/q*es.qm translations

# rm -rf lib
# El directorio lib no se borra porque hay librerías que son parte del código fuente, tampoco se crea porque ya debería existir
rm -rf lib/libicudata*
cp $1/lib/libicudata.so.73.2 lib
ln -s libicudata.so.73.2 lib/libicudata.so.73
ln -s libicudata.so.73.2 lib/libicudata.so

rm -rf lib/libicui18n*
cp $1/lib/libicui18n.so.73.2 lib
ln -s libicui18n.so.73.2 lib/libicui18n.so.73
ln -s libicui18n.so.73.2 lib/libicui18n.so

rm -rf lib/libicuuc*
cp $1/lib/libicuuc.so.73.2 lib
ln -s libicuuc.so.73.2 lib/libicuuc.so.73
ln -s libicuuc.so.73.2 lib/libicuuc.so

rm -rf lib/libQt6Charts*
cp $1/lib/libQt6Charts.so.$2 lib
ln -s libQt6Charts.so.$2 lib/libQt6Charts.so.6
ln -s libQt6Charts.so.$2 lib/libQt6Charts.so

rm -rf lib/libQt6Core*
cp $1/lib/libQt6Core.so.$2 lib
ln -s libQt6Core.so.$2 lib/libQt6Core.so.6
ln -s libQt6Core.so.$2 lib/libQt6Core.so

rm -rf lib/libQt6DBus*
cp $1/lib/libQt6DBus.so.$2 lib
ln -s libQt6DBus.so.$2 lib/libQt6DBus.so.6
ln -s libQt6DBus.so.$2 lib/libQt6DBus.so

rm -rf lib/libQt6Gui*
cp $1/lib/libQt6Gui.so.$2 lib
ln -s libQt6Gui.so.$2 lib/libQt6Gui.so.6
ln -s libQt6Gui.so.$2 lib/libQt6Gui.so

rm -rf lib/libQt6Help*
cp $1/lib/libQt6Help.so.$2 lib
ln -s libQt6Help.so.$2 lib/libQt6Help.so.6
ln -s libQt6Help.so.$2 lib/libQt6Help.so

rm -rf lib/libQt6Multimedia*
cp $1/lib/libQt6Multimedia.so.$2 lib
ln -s libQt6Multimedia.so.$2 lib/libQt6Multimedia.so.6
ln -s libQt6Multimedia.so.$2 lib/libQt6Multimedia.so

rm -rf lib/libQt6Network*
cp $1/lib/libQt6Network.so.$2 lib
ln -s libQt6Network.so.$2 lib/libQt6Network.so.6
ln -s libQt6Network.so.$2 lib/libQt6Network.so

rm -rf lib/libQt6OpenGL*
cp $1/lib/libQt6OpenGL.so.$2 lib
ln -s libQt6OpenGL.so.$2 lib/libQt6OpenGL.so.6
ln -s libQt6OpenGL.so.$2 lib/libQt6OpenGL.so

rm -rf lib/libQt6OpenGLWidgets*
cp $1/lib/libQt6OpenGLWidgets.so.$2 lib
ln -s libQt6OpenGLWidgets.so.$2 lib/libQt6OpenGLWidgets.so.6
ln -s libQt6OpenGLWidgets.so.$2 lib/libQt6OpenGLWidgets.so

rm -rf lib/libQt6PrintSupport*
cp $1/lib/libQt6PrintSupport.so.$2 lib
ln -s libQt6PrintSupport.so.$2 lib/libQt6PrintSupport.so.6
ln -s libQt6PrintSupport.so.$2 lib/libQt6PrintSupport.so

rm -rf lib/libQt6Sql*
cp $1/lib/libQt6Sql.so.$2 lib
ln -s libQt6Sql.so.$2 lib/libQt6Sql.so.6
ln -s libQt6Sql.so.$2 lib/libQt6Sql.so

rm -rf lib/libQt6Svg*
cp $1/lib/libQt6Svg.so.$2 lib
ln -s libQt6Svg.so.$2 lib/libQt6Svg.so.6
ln -s libQt6Svg.so.$2 lib/libQt6Svg.so

rm -rf lib/libQt6Widgets*
cp $1/lib/libQt6Widgets.so.$2 lib
ln -s libQt6Widgets.so.$2 lib/libQt6Widgets.so.6
ln -s libQt6Widgets.so.$2 lib/libQt6Widgets.so

rm -rf lib/libQt6XcbQpa*
cp $1/lib/libQt6XcbQpa.so.$2 lib
ln -s libQt6XcbQpa.so.$2 lib/libQt6XcbQpa.so.6
ln -s libQt6XcbQpa.so.$2 lib/libQt6XcbQpa.so

rm -rf lib/libQt6Xml*
cp $1/lib/libQt6Xml.so.$2 lib
ln -s libQt6Xml.so.$2 lib/libQt6Xml.so.6
ln -s libQt6Xml.so.$2 lib/libQt6Xml.so

rm -rf lib/libQt6Concurrent*
cp $1/lib/libQt6Concurrent.so.$2 lib
ln -s libQt6Concurrent.so.$2 lib/libQt6Concurrent.so.6
ln -s libQt6Concurrent.so.$2 lib/libQt6Concurrent.so

