/*****************************************************************************
*
* This file is part of Calíope.
* Copyright (c) 2008-2026 David Villalobos Cambronero (david.villalobos.c@gmail.com).
*
* Calíope is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Calíope is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
*
*****************************************************************************/

#include <QNetworkReply>
#include <QNetworkRequest>
#include <QFile>
#include <QMessageBox>
#include <QCoreApplication>
#include <QApplication>
#include <QProcess>
#include <QVBoxLayout>
#include <QLabel>
#include <QDialogButtonBox>
#include <QPushButton>

#include "caliopeupdater.h"

#include <QDebug>

CaliopeUpdater::CaliopeUpdater()
{
  QCoreApplication::setApplicationName("Calíope updater");
  QCoreApplication::setOrganizationName("DVC Software");
  setWindowTitle(QCoreApplication::applicationName());
  setObjectName(windowTitle());
//  setAttribute(Qt::WA_DeleteOnClose); // produces the error "double free or corruption (out)"
  setAttribute(Qt::WA_CustomWhatsThis);
  setWindowIcon(QIcon(":../images/png/256/Caliope-1.png"));

  QVBoxLayout *mainVLayout = new QVBoxLayout(this);
  setLayout(mainVLayout);
  connect(&manager, &QNetworkAccessManager::finished, this, &CaliopeUpdater::downloadFinished);
  connect(&manager2, &QNetworkAccessManager::finished, this, &CaliopeUpdater::downloadFinished2);

  //Operative system
#if defined(Q_OS_WIN)
  os = "Windows";
#elif defined(Q_OS_LINUX)
  os = "Linux";
#elif defined(Q_OS_MAC)
  os = "Mac";
#endif

  //Executable
#if defined(Q_OS_WIN)
  executable = "Calíope.exe";
#elif defined(Q_OS_LINUX)
  executable = "Caliope";
#elif defined(Q_OS_MAC)
  executable = "Caliope";
#endif

  //Application path
  applicationDirPath = QCoreApplication::applicationDirPath() + "/";

  QNetworkRequest request;
  request.setUrl(QUrl("http://ftp.caliope.org/" + os + "/" + getVersionNumber().split("-").at(1) + "/Executables/"));
  manager.get(request);
  while (!fileDownLoadFinished)
    QCoreApplication::processEvents(QEventLoop::AllEvents, 100);
  label = new QLabel(this);
  mainVLayout->addWidget(label);
  QFrame* separatorFrame = new QFrame(this);
  separatorFrame->setFrameShape(QFrame::HLine);
  mainVLayout->addWidget(separatorFrame);
  buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel | QDialogButtonBox::Close, this);
  buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);
  buttonBox->button(QDialogButtonBox::Cancel)->setEnabled(false);
  connect(buttonBox->button(QDialogButtonBox::Ok), SIGNAL(clicked()), this, SLOT(okSlot()));
  connect(buttonBox->button(QDialogButtonBox::Cancel), SIGNAL(clicked()), this, SLOT(cancelSlot()));
  connect(buttonBox->button(QDialogButtonBox::Close), SIGNAL(clicked()), this, SLOT(closeSlot()));
  mainVLayout->addWidget(buttonBox);

#if !defined(Q_OS_WIN)
  qDebug() << listOfExecutables;
  QString possibelExecutable = tr("None");
  if (listOfExecutables.count() > 0) {
    bool isNumber;
    int possibleVersionInt = listOfExecutables.last().split("-").last().toInt(&isNumber, 10);
    if (isNumber && possibleVersionInt > getVersionNumber().split("-").last().toInt()) {
        possibelExecutable = listOfExecutables.last();
        buttonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
    }
  }
  label->setText(QString("%1 %2\n\n%3 %4").arg(tr("Current version:"), getVersionNumber()
                                               , tr("Possible version:"), possibelExecutable));
#endif
}

CaliopeUpdater::~CaliopeUpdater()
{
}

void CaliopeUpdater::downloadFinished(QNetworkReply *reply)
{
  listOfExecutables.clear();
  QFile file("ListOfExecutables.html");
  if (file.open(QIODevice::WriteOnly)) {
    file.write(reply->readAll());
    file.close();
  }
  if (file.open(QIODevice::ReadOnly)) {
    while (!file.atEnd()) {
      QString line(file.readLine());
      if (line.startsWith("<li><a ") && line.endsWith("</a></li>\n")) {
        listOfExecutables.append(line.split("\"").at(1));
      }
    }
    file.close();
  }
  fileDownLoadFinished = true;

#if defined(Q_OS_WIN)
  qDebug() << listOfExecutables;
  QString possibelExecutable = tr("None");
  if (listOfExecutables.count() > 0) {
    bool isNumber;
    //Executable
    int possibleVersionInt = listOfExecutables.last().split("-").last().split(".").at(0).toInt(&isNumber, 10);
    if (isNumber && possibleVersionInt > getVersionNumber().split("-").last().toInt()) {
      possibelExecutable = listOfExecutables.last();
      buttonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
    }
  }
  label->setText(QString("%1 %2\n\n%3 %4").arg(tr("Current version:"), getVersionNumber()
                                               , tr("Possible version:"), possibelExecutable));
#endif

}

void CaliopeUpdater::downloadFinished2(QNetworkReply *reply)
{
  buttonBox->button(QDialogButtonBox::Cancel)->setEnabled(true);
  QFile::rename(applicationDirPath + executable
                , applicationDirPath + getVersionNumber());
  QFile::remove(applicationDirPath + executable);
  QFile file(listOfExecutables.last());
  if (file.open(QIODevice::WriteOnly)) {
    file.write(reply->readAll());
    file.setPermissions(file.permissions() | QFileDevice::ExeOwner);
    file.rename(executable);
    file.close();
  }
  fileDownLoadFinished2 = true;
}

void CaliopeUpdater::okSlot()
{
  QNetworkRequest request((QUrl("http://ftp.caliope.org/" + os + "/"
                                + getVersionNumber().split("-").at(1)
                                + "/Executables/"
                                + listOfExecutables.last()
                                )));
  manager2.get(request);
  QApplication::setOverrideCursor(Qt::WaitCursor);
  qDebug() << "Inicio de descarga del archivo ejecutable";
  fileDownLoadFinished2 = false;
  while (!fileDownLoadFinished2)
    QCoreApplication::processEvents(QEventLoop::AllEvents, 100);

  qDebug() << "Se supone que ya terminó";
  QApplication::restoreOverrideCursor();
  cancelSlot();
}

void CaliopeUpdater::cancelSlot()
{
  QProcess *processCaliopeUpdater = new QProcess(this);
  processCaliopeUpdater->startDetached(applicationDirPath + executable);
  close();
}

void CaliopeUpdater::closeSlot()
{
  close();
}

QString CaliopeUpdater::getVersionNumber()
{
  if (QApplication::arguments().count() > 1) {
    return QApplication::arguments().at(1);
  }
  return QString("Caliope-%1-%2").arg(qVersion(), "20251201");
}
